# Cocoon

Cocoon は、モバイル・高速化・SEO 最適化済みの WordPress テーマです。

Cocoon テーマの詳細は以下の URL を参照してください。

https://wp-cocoon.com/

利用規約はこちら。

https://wp-cocoon.com/terms-of-use/

## テーマファイルカスタマイズ

テーマファイルをカスタマイズする場合は、この親テーマをカスタマイズしてしまうと、アップデート時編集部分も上書きされてしまいます。

ですので、子テーマを利用したカスタマイズをおすすめします。

子テーマはこちらからダウンロードできます。

https://github.com/yhira/cocoon-child

## テーマライセンス

Cocoon テーマは、100％GPL です。

Cocoon（テーマ配布物）に含まれている PHP、画像、JavaScript、CSS（スキン含む）等のすべてを GPL として公開します（100%GPL）。

Cocoon テーマの再配布もしくは、Cocoon を基盤として作成したテーマを配布する場合は、配布物すべて（PHP、JavaScript、CSS、画像、その他同梱物）を GPL として公開してください（100％GPL：無料、有料問わず）。

ライセンス：[GNU General Public License](http://www.gnu.org/licenses/gpl-2.0.html)

## 開発者

わいひら： [yhira](https://github.com/yhira)

## 使用ライブラリ

[php-html-css-js-minifier.php（CSS、JavaScript、HTML の縮小化）](https://gist.github.com/tovic/d7b310dea3b33e4732c0#file-php-html-css-js-minifier-php)

[Punycode（ピュニコード変換）](https://github.com/true/php-punycode)

[Plugin Update Checker](https://github.com/YahnisElsts/plugin-update-checker)

[Open Graph Protocol helper for PHP](https://github.com/scottmac/opengraph)

## 使用リソース

[highlight.js](https://highlightjs.org/)

[Lightbox](http://lokeshdhakar.com/projects/lightbox2/)

[Lity](http://sorgalla.com/lity/)

[baguetteBox](http://feimosi.github.io/baguetteBox.js/)

[Spotlight](https://github.com/nextapps-de/spotlight)

[Masonry](http://masonry.desandro.com/)

[slicknav](https://computerwolf.github.io/SlickNav/)

[slick](http://kenwheeler.github.io/slick/)

[stickyfill](https://github.com/wilddeer/stickyfill)

[Font Awesome 4](https://fontawesome.com/v4.7.0/)

[IcoMoon](https://icomoon.io/app/)

[ScrollHint](https://appleple.github.io/scroll-hint/)

[Lozad.js](https://github.com/ApoorvSaxena/lozad.js)

[IntersectionObserver polyfill](https://github.com/w3c/IntersectionObserver/tree/master/polyfill)

[clipboard.js](https://clipboardjs.com/)

## コードを参考にしたプラグイン

[Auto Post Thumbnail](https://ja.wordpress.org/plugins/auto-post-thumbnail/)

[Youtube SpeedLoad](https://ja.wordpress.org/plugins/youtube-speedload/)

## カスタマイズ参考

[Cocoon 用記事一覧ショートコード（中古ドメイン騎士 オーラン）](https://www.orank.net/1972)

[年齢を表示するショートコード（fullnote）](https://fullnoteblog.com/age-short-code/)

[カウントダウンタイマを設置するショートコード（fullnote）](https://fullnoteblog.com/count-down-timer/)

[Gutenberg でサイドバーに選択式の CSS クラス設定を追加する（ものぐさ WEB ノート）](https://web.monogusa-note.com/gutenberg-add-select-classname)

## CSS 参考

[ボックス参考（naenote.net）](https://www.naenote.net/entry/cocoon-box-customize)

[リボン参考（nxworld）](https://www.nxworld.net/tips/pure-css-corner-ribbon.html) [(CodePen)](https://codepen.io/nxworld/pen/oLdoWb)

[ボックスメニュー参考（ぽんひろ.com）](https://ponhiro.com/box-nav/)

## ブックマークレット参考・利用

[Amazon 商品リンクブックマークレット（naenote.net）](https://www.naenote.net/entry/cocoon-amazon-shortcode-javascript)

[【電子書籍対応】Cocoon 楽天商品リンクブックマークレット（ものぐさ WEB ノート）](https://web.monogusa-note.com/cocoon-rakuten-bookmarklet)

## プルリクエストでのご協力

[technote-space](https://github.com/technote-space)

[31o3](https://github.com/31o3)

[Daisuke Sato](https://github.com/Tiryoh)

[Yukihiko Shinoda](https://github.com/yukihiko-shinoda)

[stedplay](https://github.com/stedplay)

[1008k](https://github.com/1008k)

[Wren Hainsworth](https://github.com/WrenHainsworth)

[semicolon3253](https://github.com/semicolon3253)

[tsukumi](https://github.com/tsukumijima)

[taako](https://github.com/taako-502)

[takumiando](https://github.com/takumiando)

[Takeyuki Miyagi](https://github.com/v97ug)

[hausercarl](https://github.com/hausercarl)

[mirumi](https://github.com/mirumirumi)

[vic322](https://github.com/vic322)
