<?php //Font Awesome関係
/**
 * Cocoon WordPress Theme
 * @author: yhira
 * @link: https://wp-cocoon.com/
 * @license: http://www.gnu.org/licenses/gpl-2.0.html GPL v2 or later
 */
if ( !defined( 'ABSPATH' ) ) exit;

//サイトアイコンフォントのURLを取得
if ( !function_exists( 'get_site_icon_font_url' ) ):
function get_site_icon_font_url(){
  $url = FONT_AWESOME_4_URL;
  switch (get_site_icon_font()) {
    case 'font_awesome_5':
      $url = FONT_AWESOME_5_URL;
      break;
  }
  return $url;
}
endif;

//サイトアイコンフォントのCDN URLを取得
if ( !function_exists( 'get_site_icon_font_cdn_url' ) ):
function get_site_icon_font_cdn_url(){
  $url = FONT_AWESOME_4_CDN_URL;
  switch (get_site_icon_font()) {
    case 'font_awesome_5':
      $url = FONT_AWESOME_5_CDN_URL;
      break;
  }
  return $url;
}
endif;

//Font Awesome置換リストの取得
if ( !function_exists( 'get_font_awesome_exchange_list' ) ):
function get_font_awesome_exchange_list(){
  $list = array(
    array('fa fa-500px', 'fab fa-500px'),
    array('fa fa-address-book-o', 'far fa-address-book'),
    array('fa fa-address-card-o', 'far fa-address-card'),
    array('fa fa-adn', 'fab fa-adn'),
    array('fa fa-amazon', 'fab fa-amazon'),
    array('fa fa-android', 'fab fa-android'),
    array('fa fa-angellist', 'fab fa-angellist'),
    array('fa fa-apple', 'fab fa-apple'),
    array('fa fa-area-chart', 'fas fa-chart-area'),
    array('fa fa-arrow-circle-o-down', 'far fa-arrow-alt-circle-down'),
    array('fa fa-arrow-circle-o-left', 'far fa-arrow-alt-circle-left'),
    array('fa fa-arrow-circle-o-right', 'far fa-arrow-alt-circle-right'),
    array('fa fa-arrow-circle-o-up', 'far fa-arrow-alt-circle-up'),
    array('fa fa-arrows', 'fas fa-arrows-alt'),
    array('fa fa-arrows-alt', 'fas fa-expand-arrows-alt'),
    array('fa fa-arrows-h', 'fas fa-arrows-alt-h'),
    array('fa fa-arrows-v', 'fas fa-arrows-alt-v'),
    array('fa fa-asl-interpreting', 'fas fa-american-sign-language-interpreting'),
    array('fa fa-automobile', 'fas fa-car'),
    array('fa fa-bandcamp', 'fab fa-bandcamp'),
    array('fa fa-bank', 'fas fa-university'),
    array('fa fa-bar-chart', 'far fa-chart-bar'),
    array('fa fa-bar-chart-o', 'far fa-chart-bar'),
    array('fa fa-bathtub', 'fas fa-bath'),
    array('fa fa-battery', 'fas fa-battery-full'),
    array('fa fa-battery-0', 'fas fa-battery-empty'),
    array('fa fa-battery-1', 'fas fa-battery-quarter'),
    array('fa fa-battery-2', 'fas fa-battery-half'),
    array('fa fa-battery-3', 'fas fa-battery-three-quarters'),
    array('fa fa-battery-4', 'fas fa-battery-full'),
    array('fa fa-behance', 'fab fa-behance'),
    array('fa fa-behance-square', 'fab fa-behance-square'),
    array('fa fa-bell-o', 'far fa-bell'),
    array('fa fa-bell-slash-o', 'far fa-bell-slash'),
    array('fa fa-bitbucket', 'fab fa-bitbucket'),
    array('fa fa-bitbucket-square', 'fab fa-bitbucket'),
    array('fa fa-bitcoin', 'fab fa-btc'),
    array('fa fa-black-tie', 'fab fa-black-tie'),
    array('fa fa-bluetooth', 'fab fa-bluetooth'),
    array('fa fa-bluetooth-b', 'fab fa-bluetooth-b'),
    array('fa fa-bookmark-o', 'far fa-bookmark'),
    array('fa fa-btc', 'fab fa-btc'),
    array('fa fa-building-o', 'far fa-building'),
    array('fa fa-buysellads', 'fab fa-buysellads'),
    array('fa fa-cab', 'fas fa-taxi'),
    array('fa fa-calendar', 'fas fa-calendar-alt'),
    array('fa fa-calendar-check-o', 'far fa-calendar-check'),
    array('fa fa-calendar-minus-o', 'far fa-calendar-minus'),
    array('fa fa-calendar-o', 'far fa-calendar'),
    array('fa fa-calendar-plus-o', 'far fa-calendar-plus'),
    array('fa fa-calendar-times-o', 'far fa-calendar-times'),
    array('fa fa-caret-square-o-down', 'far fa-caret-square-down'),
    array('fa fa-caret-square-o-left', 'far fa-caret-square-left'),
    array('fa fa-caret-square-o-right', 'far fa-caret-square-right'),
    array('fa fa-caret-square-o-up', 'far fa-caret-square-up'),
    array('fa fa-cc', 'far fa-closed-captioning'),
    array('fa fa-cc-amex', 'fab fa-cc-amex'),
    array('fa fa-cc-diners-club', 'fab fa-cc-diners-club'),
    array('fa fa-cc-discover', 'fab fa-cc-discover'),
    array('fa fa-cc-jcb', 'fab fa-cc-jcb'),
    array('fa fa-cc-mastercard', 'fab fa-cc-mastercard'),
    array('fa fa-cc-paypal', 'fab fa-cc-paypal'),
    array('fa fa-cc-stripe', 'fab fa-cc-stripe'),
    array('fa fa-cc-visa', 'fab fa-cc-visa'),
    array('fa fa-chain', 'fas fa-link'),
    array('fa fa-chain-broken', 'fas fa-unlink'),
    array('fa fa-check-circle-o', 'far fa-check-circle'),
    array('fa fa-check-square-o', 'far fa-check-square'),
    array('fa fa-chrome', 'fab fa-chrome'),
    array('fa fa-circle-o', 'far fa-circle'),
    array('fa fa-circle-o-notch', 'fas fa-circle-notch'),
    array('fa fa-circle-thin', 'far fa-circle'),
    array('fa fa-clipboard', 'far fa-clipboard'),
    array('fa fa-clock-o', 'far fa-clock'),
    array('fa fa-clone', 'far fa-clone'),
    array('fa fa-close', 'fas fa-times'),
    array('fa fa-cloud-download', 'fas fa-cloud-download-alt'),
    array('fa fa-cloud-upload', 'fas fa-cloud-upload-alt'),
    array('fa fa-cny', 'fas fa-yen-sign'),
    array('fa fa-code-fork', 'fas fa-code-branch'),
    array('fa fa-codepen', 'fab fa-codepen'),
    array('fa fa-codiepie', 'fab fa-codiepie'),
    array('fa fa-comment-o', 'far fa-comment'),
    array('fa fa-commenting', 'fas fa-comment-dots'),
    array('fa fa-commenting-o', 'far fa-comment-dots'),
    array('fa fa-comments-o', 'far fa-comments'),
    array('fa fa-compass', 'far fa-compass'),
    array('fa fa-connectdevelop', 'fab fa-connectdevelop'),
    array('fa fa-contao', 'fab fa-contao'),
    array('fa fa-copyright', 'far fa-copyright'),
    array('fa fa-creative-commons', 'fab fa-creative-commons'),
    array('fa fa-credit-card', 'far fa-credit-card'),
    array('fa fa-credit-card-alt', 'fas fa-credit-card'),
    array('fa fa-css3', 'fab fa-css3'),
    array('fa fa-cutlery', 'fas fa-utensils'),
    array('fa fa-dashboard', 'fas fa-tachometer-alt'),
    array('fa fa-dashcube', 'fab fa-dashcube'),
    array('fa fa-deafness', 'fas fa-deaf'),
    array('fa fa-dedent', 'fas fa-outdent'),
    array('fa fa-delicious', 'fab fa-delicious'),
    array('fa fa-deviantart', 'fab fa-deviantart'),
    array('fa fa-diamond', 'far fa-gem'),
    array('fa fa-digg', 'fab fa-digg'),
    array('fa fa-dollar', 'fas fa-dollar-sign'),
    array('fa fa-dot-circle-o', 'far fa-dot-circle'),
    array('fa fa-dribbble', 'fab fa-dribbble'),
    array('fa fa-drivers-license', 'fas fa-id-card'),
    array('fa fa-drivers-license-o', 'far fa-id-card'),
    array('fa fa-dropbox', 'fab fa-dropbox'),
    array('fa fa-drupal', 'fab fa-drupal'),
    array('fa fa-edge', 'fab fa-edge'),
    array('fa fa-eercast', 'fab fa-sellcast'),
    array('fa fa-empire', 'fab fa-empire'),
    array('fa fa-envelope-o', 'far fa-envelope'),
    array('fa fa-envelope-open-o', 'far fa-envelope-open'),
    array('fa fa-envira', 'fab fa-envira'),
    array('fa fa-etsy', 'fab fa-etsy'),
    array('fa fa-eur', 'fas fa-euro-sign'),
    array('fa fa-euro', 'fas fa-euro-sign'),
    array('fa fa-exchange', 'fas fa-exchange-alt'),
    array('fa fa-expeditedssl', 'fab fa-expeditedssl'),
    array('fa fa-external-link', 'fas fa-external-link-alt'),
    array('fa fa-external-link-square', 'fas fa-external-link-square-alt'),
    array('fa fa-eye', 'far fa-eye'),
    array('fa fa-eye-slash', 'far fa-eye-slash'),
    array('fa fa-eyedropper', 'fas fa-eye-dropper'),
    array('fa fa-fa', 'fab fa-font-awesome'),
    array('fa fa-facebook', 'fab', 'facebook-f'),
    array('fa fa-facebook-f', 'fab', 'facebook-f'),
    array('fa fa-facebook-official', 'fab', 'facebook'),
    array('fa fa-facebook-square', 'fab', 'facebook-square'),
    array('fa fa-feed', 'fas fa-rss'),
    array('fa fa-file-archive-o', 'far fa-file-archive'),
    array('fa fa-file-audio-o', 'far fa-file-audio'),
    array('fa fa-file-code-o', 'far fa-file-code'),
    array('fa fa-file-excel-o', 'far fa-file-excel'),
    array('fa fa-file-image-o', 'far fa-file-image'),
    array('fa fa-file-movie-o', 'far fa-file-video'),
    array('fa fa-file-o', 'far fa-file'),
    array('fa fa-file-pdf-o', 'far fa-file-pdf'),
    array('fa fa-file-photo-o', 'far fa-file-image'),
    array('fa fa-file-picture-o', 'far fa-file-image'),
    array('fa fa-file-powerpoint-o', 'far fa-file-powerpoint'),
    array('fa fa-file-sound-o', 'far fa-file-audio'),
    array('fa fa-file-text', 'fas fa-file-alt'),
    array('fa fa-file-text-o', 'far fa-file-alt'),
    array('fa fa-file-video-o', 'far fa-file-video'),
    array('fa fa-file-word-o', 'far fa-file-word'),
    array('fa fa-file-zip-o', 'far fa-file-archive'),
    array('fa fa-files-o', 'far fa-copy'),
    array('fa fa-firefox', 'fab fa-firefox'),
    array('fa fa-first-order', 'fab fa-first-order'),
    array('fa fa-flag-o', 'far fa-flag'),
    array('fa fa-flash', 'fas fa-bolt'),
    array('fa fa-flickr', 'fab fa-flickr'),
    array('fa fa-floppy-o', 'far fa-save'),
    array('fa fa-folder-o', 'far fa-folder'),
    array('fa fa-folder-open-o', 'far fa-folder-open'),
    array('fa fa-font-awesome', 'fab fa-font-awesome'),
    array('fa fa-fonticons', 'fab fa-fonticons'),
    array('fa fa-fort-awesome', 'fab fa-fort-awesome'),
    array('fa fa-forumbee', 'fab fa-forumbee'),
    array('fa fa-foursquare', 'fab fa-foursquare'),
    array('fa fa-free-code-camp', 'fab fa-free-code-camp'),
    array('fa fa-frown-o', 'far fa-frown'),
    array('fa fa-futbol-o', 'far fa-futbol'),
    array('fa fa-gbp', 'fas fa-pound-sign'),
    array('fa fa-ge', 'fab fa-empire'),
    array('fa fa-gear', 'fas fa-cog'),
    array('fa fa-gears', 'fas fa-cogs'),
    array('fa fa-get-pocket', 'fab fa-get-pocket'),
    array('fa fa-gg', 'fab fa-gg'),
    array('fa fa-gg-circle', 'fab fa-gg-circle'),
    array('fa fa-git', 'fab fa-git'),
    array('fa fa-git-square', 'fab fa-git-square'),
    array('fa fa-github', 'fab fa-github'),
    array('fa fa-github-alt', 'fab fa-github-alt'),
    array('fa fa-github-square', 'fab fa-github-square'),
    array('fa fa-gitlab', 'fab fa-gitlab'),
    array('fa fa-gittip', 'fab fa-gratipay'),
    array('fa fa-glass', 'fas fa-glass-martini'),
    array('fa fa-glide', 'fab fa-glide'),
    array('fa fa-glide-g', 'fab fa-glide-g'),
    array('fa fa-google', 'fab fa-google'),
    array('fa fa-google-plus', 'fab fa-google-plus-g'),
    array('fa fa-google-plus-circle', 'fab fa-google-plus'),
    array('fa fa-google-plus-official', 'fab fa-google-plus'),
    array('fa fa-google-plus-square', 'fab fa-google-plus-square'),
    array('fa fa-google-wallet', 'fab fa-google-wallet'),
    array('fa fa-gratipay', 'fab fa-gratipay'),
    array('fa fa-grav', 'fab fa-grav'),
    array('fa fa-group', 'fas fa-users'),
    array('fa fa-hacker-news', 'fab fa-hacker-news'),
    array('fa fa-hand-grab-o', 'far fa-hand-rock'),
    array('fa fa-hand-lizard-o', 'far fa-hand-lizard'),
    array('fa fa-hand-o-down', 'far fa-hand-point-down'),
    array('fa fa-hand-o-left', 'far fa-hand-point-left'),
    array('fa fa-hand-o-right', 'far fa-hand-point-right'),
    array('fa fa-hand-o-up', 'far fa-hand-point-up'),
    array('fa fa-hand-paper-o', 'far fa-hand-paper'),
    array('fa fa-hand-peace-o', 'far fa-hand-peace'),
    array('fa fa-hand-pointer-o', 'far fa-hand-pointer'),
    array('fa fa-hand-rock-o', 'far fa-hand-rock'),
    array('fa fa-hand-scissors-o', 'far fa-hand-scissors'),
    array('fa fa-hand-spock-o', 'far fa-hand-spock'),
    array('fa fa-hand-stop-o', 'far fa-hand-paper'),
    array('fa fa-handshake-o', 'far fa-handshake'),
    array('fa fa-hard-of-hearing', 'fas fa-deaf'),
    array('fa fa-hdd-o', 'far fa-hdd'),
    array('fa fa-header', 'fas fa-heading'),
    array('fa fa-heart-o', 'far fa-heart'),
    array('fa fa-hospital-o', 'far fa-hospital'),
    array('fa fa-hotel', 'fas fa-bed'),
    array('fa fa-hourglass-1', 'fas fa-hourglass-start'),
    array('fa fa-hourglass-2', 'fas fa-hourglass-half'),
    array('fa fa-hourglass-3', 'fas fa-hourglass-end'),
    array('fa fa-hourglass-o', 'far fa-hourglass'),
    array('fa fa-houzz', 'fab fa-houzz'),
    array('fa fa-html5', 'fab fa-html5'),
    array('fa fa-id-badge', 'far fa-id-badge'),
    array('fa fa-id-card-o', 'far fa-id-card'),
    array('fa fa-ils', 'fas fa-shekel-sign'),
    array('fa fa-image', 'far fa-image'),
    array('fa fa-imdb', 'fab fa-imdb'),
    array('fa fa-inr', 'fas fa-rupee-sign'),
    array('fa fa-instagram', 'fab fa-instagram'),
    array('fa fa-institution', 'fas fa-university'),
    array('fa fa-internet-explorer', 'fab fa-internet-explorer'),
    array('fa fa-intersex', 'fas fa-transgender'),
    array('fa fa-ioxhost', 'fab fa-ioxhost'),
    array('fa fa-joomla', 'fab fa-joomla'),
    array('fa fa-jpy', 'fas fa-yen-sign'),
    array('fa fa-jsfiddle', 'fab fa-jsfiddle'),
    array('fa fa-keyboard-o', 'far fa-keyboard'),
    array('fa fa-krw', 'fas fa-won-sign'),
    array('fa fa-lastfm', 'fab fa-lastfm'),
    array('fa fa-lastfm-square', 'fab fa-lastfm-square'),
    array('fa fa-leanpub', 'fab fa-leanpub'),
    array('fa fa-legal', 'fas fa-gavel'),
    array('fa fa-lemon-o', 'far fa-lemon'),
    array('fa fa-level-down', 'fas fa-level-down-alt'),
    array('fa fa-level-up', 'fas fa-level-up-alt'),
    array('fa fa-life-bouy', 'far fa-life-ring'),
    array('fa fa-life-buoy', 'far fa-life-ring'),
    array('fa fa-life-ring', 'far fa-life-ring'),
    array('fa fa-life-saver', 'far fa-life-ring'),
    array('fa fa-lightbulb-o', 'far fa-lightbulb'),
    array('fa fa-line-chart', 'fas fa-chart-line'),
    array('fa fa-linkedin', 'fab fa-linkedin-in'),
    array('fa fa-linkedin-square', 'fab fa-linkedin'),
    array('fa fa-linode', 'fab fa-linode'),
    array('fa fa-linux', 'fab fa-linux'),
    array('fa fa-list-alt', 'far fa-list-alt'),
    array('fa fa-long-arrow-down', 'fas fa-long-arrow-alt-down'),
    array('fa fa-long-arrow-left', 'fas fa-long-arrow-alt-left'),
    array('fa fa-long-arrow-right', 'fas fa-long-arrow-alt-right'),
    array('fa fa-long-arrow-up', 'fas fa-long-arrow-alt-up'),
    array('fa fa-mail-forward', 'fas fa-share'),
    array('fa fa-mail-reply', 'fas fa-reply'),
    array('fa fa-mail-reply-all', 'fas fa-reply-all'),
    array('fa fa-map-marker', 'fas fa-map-marker-alt'),
    array('fa fa-map-o', 'far fa-map'),
    array('fa fa-maxcdn', 'fab fa-maxcdn'),
    array('fa fa-meanpath', 'fab fa-font-awesome'),
    array('fa fa-medium', 'fab fa-medium'),
    array('fa fa-meetup', 'fab fa-meetup'),
    array('fa fa-meh-o', 'far fa-meh'),
    array('fa fa-minus-square-o', 'far fa-minus-square'),
    array('fa fa-mixcloud', 'fab fa-mixcloud'),
    array('fa fa-mobile', 'fas fa-mobile-alt'),
    array('fa fa-mobile-phone', 'fas fa-mobile-alt'),
    array('fa fa-modx', 'fab fa-modx'),
    array('fa fa-money', 'far fa-money-bill-alt'),
    array('fa fa-moon-o', 'far fa-moon'),
    array('fa fa-mortar-board', 'fas fa-graduation-cap'),
    array('fa fa-navicon', 'fas fa-bars'),
    array('fa fa-newspaper-o', 'far fa-newspaper'),
    array('fa fa-object-group', 'far fa-object-group'),
    array('fa fa-object-ungroup', 'far fa-object-ungroup'),
    array('fa fa-odnoklassniki', 'fab fa-odnoklassniki'),
    array('fa fa-odnoklassniki-square', 'fab fa-odnoklassniki-square'),
    array('fa fa-opencart', 'fab fa-opencart'),
    array('fa fa-openid', 'fab fa-openid'),
    array('fa fa-opera', 'fab fa-opera'),
    array('fa fa-optin-monster', 'fab fa-optin-monster'),
    array('fa fa-pagelines', 'fab fa-pagelines'),
    array('fa fa-paper-plane-o', 'far fa-paper-plane'),
    array('fa fa-paste', 'far fa-clipboard'),
    array('fa fa-pause-circle-o', 'far fa-pause-circle'),
    array('fa fa-paypal', 'fab fa-paypal'),
    array('fa fa-pencil', 'fas fa-pencil-alt'),
    array('fa fa-pencil-square', 'fas fa-pen-square'),
    array('fa fa-pencil-square-o', 'far fa-edit'),
    array('fa fa-photo', 'far fa-image'),
    array('fa fa-picture-o', 'far fa-image'),
    array('fa fa-pie-chart', 'fas fa-chart-pie'),
    array('fa fa-pied-piper', 'fab fa-pied-piper'),
    array('fa fa-pied-piper-alt', 'fab fa-pied-piper-alt'),
    array('fa fa-pied-piper-pp', 'fab fa-pied-piper-pp'),
    array('fa fa-pinterest', 'fab fa-pinterest'),
    array('fa fa-pinterest-p', 'fab fa-pinterest-p'),
    array('fa fa-pinterest-square', 'fab fa-pinterest-square'),
    array('fa fa-play-circle-o', 'far fa-play-circle'),
    array('fa fa-plus-square-o', 'far fa-plus-square'),
    array('fa fa-product-hunt', 'fab fa-product-hunt'),
    array('fa fa-qq', 'fab fa-qq'),
    array('fa fa-question-circle-o', 'far fa-question-circle'),
    array('fa fa-quora', 'fab fa-quora'),
    array('fa fa-ra', 'fab fa-rebel'),
    array('fa fa-ravelry', 'fab fa-ravelry'),
    array('fa fa-rebel', 'fab fa-rebel'),
    array('fa fa-reddit', 'fab fa-reddit'),
    array('fa fa-reddit-alien', 'fab fa-reddit-alien'),
    array('fa fa-reddit-square', 'fab fa-reddit-square'),
    array('fa fa-refresh', 'fas fa-sync'),
    array('fa fa-registered', 'far fa-registered'),
    array('fa fa-remove', 'fas fa-times'),
    array('fa fa-renren', 'fab fa-renren'),
    array('fa fa-reorder', 'fas fa-bars'),
    array('fa fa-repeat', 'fas fa-redo'),
    array('fa fa-resistance', 'fab fa-rebel'),
    array('fa fa-rmb', 'fas fa-yen-sign'),
    array('fa fa-rotate-left', 'fas fa-undo'),
    array('fa fa-rotate-right', 'fas fa-redo'),
    array('fa fa-rouble', 'fas fa-ruble-sign'),
    array('fa fa-rub', 'fas fa-ruble-sign'),
    array('fa fa-ruble', 'fas fa-ruble-sign'),
    array('fa fa-rupee', 'fas fa-rupee-sign'),
    array('fa fa-s15', 'fas fa-bath'),
    array('fa fa-safari', 'fab fa-safari'),
    array('fa fa-scissors', 'fas fa-cut'),
    array('fa fa-scribd', 'fab fa-scribd'),
    array('fa fa-sellsy', 'fab fa-sellsy'),
    array('fa fa-send', 'fas fa-paper-plane'),
    array('fa fa-send-o', 'far fa-paper-plane'),
    array('fa fa-share-square-o', 'far fa-share-square'),
    array('fa fa-shekel', 'fas fa-shekel-sign'),
    array('fa fa-sheqel', 'fas fa-shekel-sign'),
    array('fa fa-shield', 'fas fa-shield-alt'),
    array('fa fa-shirtsinbulk', 'fab fa-shirtsinbulk'),
    array('fa fa-sign-in', 'fas fa-sign-in-alt'),
    array('fa fa-sign-out', 'fas fa-sign-out-alt'),
    array('fa fa-signing', 'fas fa-sign-language'),
    array('fa fa-simplybuilt', 'fab fa-simplybuilt'),
    array('fa fa-skyatlas', 'fab fa-skyatlas'),
    array('fa fa-skype', 'fab fa-skype'),
    array('fa fa-slack', 'fab fa-slack'),
    array('fa fa-sliders', 'fas fa-sliders-h'),
    array('fa fa-slideshare', 'fab fa-slideshare'),
    array('fa fa-smile-o', 'far fa-smile'),
    array('fa fa-snapchat', 'fab fa-snapchat'),
    array('fa fa-snapchat-ghost', 'fab fa-snapchat-ghost'),
    array('fa fa-snapchat-square', 'fab fa-snapchat-square'),
    array('fa fa-snowflake-o', 'far fa-snowflake'),
    array('fa fa-soccer-ball-o', 'far fa-futbol'),
    array('fa fa-sort-alpha-asc', 'fas fa-sort-alpha-down'),
    array('fa fa-sort-alpha-desc', 'fas fa-sort-alpha-up'),
    array('fa fa-sort-amount-asc', 'fas fa-sort-amount-down'),
    array('fa fa-sort-amount-desc', 'fas fa-sort-amount-up'),
    array('fa fa-sort-asc', 'fas fa-sort-up'),
    array('fa fa-sort-desc', 'fas fa-sort-down'),
    array('fa fa-sort-numeric-asc', 'fas fa-sort-numeric-down'),
    array('fa fa-sort-numeric-desc', 'fas fa-sort-numeric-up'),
    array('fa fa-soundcloud', 'fab fa-soundcloud'),
    array('fa fa-spoon', 'fas fa-utensil-spoon'),
    array('fa fa-spotify', 'fab fa-spotify'),
    array('fa fa-square-o', 'far fa-square'),
    array('fa fa-stack-exchange', 'fab fa-stack-exchange'),
    array('fa fa-stack-overflow', 'fab fa-stack-overflow'),
    array('fa fa-star-half', 'far fa-star-half'),
    array('fa fa-star-half-empty', 'fas fa-star-half-alt'),
    array('fa fa-star-half-full', 'fas fa-star-half-alt'),
    array('fa fa-star-half-o', 'fas fa-star-half-alt'),
    array('fa fa-star-o', 'far fa-star'),
    array('fa fa-steam', 'fab fa-steam'),
    array('fa fa-steam-square', 'fab fa-steam-square'),
    array('fa fa-sticky-note-o', 'far fa-sticky-note'),
    array('fa fa-stop-circle-o', 'far fa-stop-circle'),
    array('fa fa-stumbleupon', 'fab fa-stumbleupon'),
    array('fa fa-stumbleupon-circle', 'fab fa-stumbleupon-circle'),
    array('fa fa-sun-o', 'far fa-sun'),
    array('fa fa-superpowers', 'fab fa-superpowers'),
    array('fa fa-support', 'far fa-life-ring'),
    array('fa fa-tablet', 'fas fa-tablet-alt'),
    array('fa fa-tachometer', 'fas fa-tachometer-alt'),
    array('fa fa-telegram', 'fab fa-telegram'),
    array('fa fa-television', 'fas fa-tv'),
    array('fa fa-tencent-weibo', 'fab fa-tencent-weibo'),
    array('fa fa-themeisle', 'fab fa-themeisle'),
    array('fa fa-thermometer', 'fas fa-thermometer-full'),
    array('fa fa-thermometer-0', 'fas fa-thermometer-empty'),
    array('fa fa-thermometer-1', 'fas fa-thermometer-quarter'),
    array('fa fa-thermometer-2', 'fas fa-thermometer-half'),
    array('fa fa-thermometer-3', 'fas fa-thermometer-three-quarters'),
    array('fa fa-thermometer-4', 'fas fa-thermometer-full'),
    array('fa fa-thumb-tack', 'fas fa-thumbtack'),
    array('fa fa-thumbs-o-down', 'far fa-thumbs-down'),
    array('fa fa-thumbs-o-up', 'far fa-thumbs-up'),
    array('fa fa-ticket', 'fas fa-ticket-alt'),
    array('fa fa-times-circle-o', 'far fa-times-circle'),
    array('fa fa-times-rectangle', 'fas fa-window-close'),
    array('fa fa-times-rectangle-o', 'far fa-window-close'),
    array('fa fa-toggle-down', 'far fa-caret-square-down'),
    array('fa fa-toggle-left', 'far fa-caret-square-left'),
    array('fa fa-toggle-right', 'far fa-caret-square-right'),
    array('fa fa-toggle-up', 'far fa-caret-square-up'),
    array('fa fa-trash', 'fas fa-trash-alt'),
    array('fa fa-trash-o', 'far fa-trash-alt'),
    array('fa fa-trello', 'fab fa-trello'),
    array('fa fa-tripadvisor', 'fab fa-tripadvisor'),
    array('fa fa-try', 'fas fa-lira-sign'),
    array('fa fa-tumblr', 'fab fa-tumblr'),
    array('fa fa-tumblr-square', 'fab fa-tumblr-square'),
    array('fa fa-turkish-lira', 'fas fa-lira-sign'),
    array('fa fa-twitch', 'fab fa-twitch'),
    array('fa fa-twitter', 'fab fa-twitter'),
    array('fa fa-twitter-square', 'fab fa-twitter-square'),
    array('fa fa-unsorted', 'fas fa-sort'),
    array('fa fa-usb', 'fab fa-usb'),
    array('fa fa-usd', 'fas fa-dollar-sign'),
    array('fa fa-user-circle-o', 'far fa-user-circle'),
    array('fa fa-user-o', 'far fa-user'),
    array('fa fa-vcard', 'fas fa-address-card'),
    array('fa fa-vcard-o', 'far fa-address-card'),
    array('fa fa-viacoin', 'fab fa-viacoin'),
    array('fa fa-viadeo', 'fab fa-viadeo'),
    array('fa fa-viadeo-square', 'fab fa-viadeo-square'),
    array('fa fa-video-camera', 'fas fa-video'),
    array('fa fa-vimeo', 'fab fa-vimeo-v'),
    array('fa fa-vimeo-square', 'fab fa-vimeo-square'),
    array('fa fa-vine', 'fab fa-vine'),
    array('fa fa-vk', 'fab fa-vk'),
    array('fa fa-volume-control-phone', 'fas fa-phone-volume'),
    array('fa fa-warning', 'fas fa-exclamation-triangle'),
    array('fa fa-wechat', 'fab fa-weixin'),
    array('fa fa-weibo', 'fab fa-weibo'),
    array('fa fa-weixin', 'fab fa-weixin'),
    array('fa fa-whatsapp', 'fab fa-whatsapp'),
    array('fa fa-wheelchair-alt', 'fab fa-accessible-icon'),
    array('fa fa-wikipedia-w', 'fab fa-wikipedia-w'),
    array('fa fa-window-close-o', 'far fa-window-close'),
    array('fa fa-window-maximize', 'far fa-window-maximize'),
    array('fa fa-window-restore', 'far fa-window-restore'),
    array('fa fa-windows', 'fab fa-windows'),
    array('fa fa-won', 'fas fa-won-sign'),
    array('fa fa-wordpress', 'fab fa-wordpress'),
    array('fa fa-wpbeginner', 'fab fa-wpbeginner'),
    array('fa fa-wpexplorer', 'fab fa-wpexplorer'),
    array('fa fa-wpforms', 'fab fa-wpforms'),
    array('fa fa-xing', 'fab fa-xing'),
    array('fa fa-xing-square', 'fab fa-xing-square'),
    array('fa fa-y-combinator', 'fab fa-y-combinator'),
    array('fa fa-y-combinator-square', 'fab fa-hacker-news'),
    array('fa fa-yahoo', 'fab fa-yahoo'),
    array('fa fa-yc', 'fab fa-y-combinator'),
    array('fa fa-yc-square', 'fab fa-hacker-news'),
    array('fa fa-yelp', 'fab fa-yelp'),
    array('fa fa-yen', 'fas fa-yen-sign'),
    array('fa fa-yoast', 'fab fa-yoast'),
    array('fa fa-youtube', 'fab fa-youtube'),
    array('fa fa-youtube-play', 'fab fa-youtube'),
    array('fa fa-youtube-square', 'fab fa-youtube-square'),
  );
  return $list;
}
endif;
